import ./macros/rng.mcm

function load {
    kill @e[tag=menu]
    kill @e[tag=menu_animatronic]
    kill @e[tag=menu_text]
    kill @e[tag=menu_mount]
    kill @e[tag=menu_interact]
    kill @e[tag=lobby_spawn]
    summon marker -25 -60 244 {Tags:["menu"]}
    summon marker -22 -60 244 {Tags:["menu"]}
    # setblock -28 -59 244 light[level=10]
    # setblock -20 -59 244 light[level=10]
    setblock -23 -60 249 air
    scoreboard players set menu ak.state 0
    scoreboard players set menu_trigger ak.state 0
    effect clear @a minecraft:slowness
    function audio:lobby/stop
    function audio:lobby/stop.loop
    time set midnight
    summon marker -23.63 -60.00 266.25 {Tags:["lobby_spawn"]}
	schedule clear menu:static_event
	schedule clear menu:lobby_event
	schedule clear menu:golden_freddy_slump_event
	schedule clear menu:animatronic_head_event
	scoreboard players set door_open ak.state 0
}

clock 40t {
    rng range 0 120 temp ak.state
    execute if score temp ak.state matches ..30 run {
        item replace entity @e[tag=menu_animatronic] container.0 with potion{CustomModelData:990105}
        schedule 1t replace {
            item replace entity @e[tag=menu_animatronic] container.0 with potion{CustomModelData:990104}
        }
    } 
    execute if score temp ak.state matches 31..50 run {
        item replace entity @e[tag=menu_animatronic] container.0 with potion{CustomModelData:990103}
        schedule 1t replace {
            item replace entity @e[tag=menu_animatronic] container.0 with potion{CustomModelData:990104}
        }
    } 
}

clock 200s {
	schedule 200s append {
		name lobby_event
		execute unless score in_between_night_active ak.state matches 1 unless score power_remix_active ak.state matches 1 unless score menu ak.state matches 1 unless score night_active ak.state matches 1 unless score cutscene_active ak.state matches 1 run{
			function audio:lobby/stop
			function audio:lobby/start.light
			rng range 0 100 temp ak.state
			execute if score temp ak.state matches ..50 run {
				execute at @a run playsound minecraft:entity.villager.death master @a ~ ~ ~ 0.2
				schedule 59s replace {
					function audio:lobby/stop
				}
			}	
			execute if score temp ak.state matches 51.. run {
				execute at @a run playsound minecraft:entity.cat.hiss master @a ~ ~ ~ 0.2
				schedule 5s replace {
					function audio:lobby/stop
				}
			}
		}
	}
}

clock 300s {
	schedule 300s append {
		name static_event
		execute unless score in_between_night_active ak.state matches 1 unless score power_remix_active ak.state matches 1 unless score menu ak.state matches 1 unless score night_active ak.state matches 1 unless score cutscene_active ak.state matches 1 run {
			execute at @a run playsound minecraft:generic.lobby.long_static master @a ~ ~ ~ 0.15
		}
	}
	
}

clock 62s {
	execute unless score in_between_night_active ak.state matches 1 unless score power_remix_active ak.state matches 1 unless score menu ak.state matches 1 unless score night_active ak.state matches 1 unless score cutscene_active ak.state matches 1 run {
		execute at @a run playsound minecraft:generic.lobby.loop master @a ~ ~ ~ 0.1
	}
}

# slumped golden freddy
clock 660s {
	schedule 660s append {
		name golden_freddy_slump_event
		execute unless score in_between_night_active ak.state matches 1 unless score power_remix_active ak.state matches 1 unless score menu ak.state matches 1 unless score night_active ak.state matches 1 unless score cutscene_active ak.state matches 1 run {
			name golden_freddy_jumpscare
			summon item_display -24 -59.5 244 {item:{id:"potion",Count:1,tag:{CustomModelData:990501}},Tags:["golden_freddy","animatronic"],brightness:{sky:6,block:6}}
			execute positioned -24 -59.5 244 run playsound minecraft:entity.bat.loop master @a ~ ~ ~ 100 1 1
			schedule 3s replace {
				kill @e[tag=golden_freddy]
				stopsound @a master minecraft:entity.bat.loop
			}
		}
	}
	
}

# animatronic head will flash in front of the player's head
clock 450s {
	schedule 450s append {
		name animatronic_head_event
		execute unless score in_between_night_active ak.state matches 1 unless score power_remix_active ak.state matches 1 unless score menu ak.state matches 1 unless score night_active ak.state matches 1 unless score cutscene_active ak.state matches 1 run {
			scoreboard players set hallucination jc.anim 80
			execute at @a run playsound minecraft:generic.golden_freddy.talk master @a
			schedule 80t replace {
				stopsound @a master minecraft:generic.golden_freddy.talk
			}
		}
	}
	
}

function jumpscare {
	rng range 0 100 temp ak.state
	execute(if score temp ak.state matches ..50) {
		summon minecraft:item_display 0 0 0 {item:{id:"potion",Count:1,tag:{CustomModelData:990310}},Tags:["animatronic_head","animatronic"],brightness:{sky:10,block:10}}
	} else {
		summon minecraft:item_display 0 0 0 {item:{id:"potion",Count:1,tag:{CustomModelData:990410}},Tags:["animatronic_head","animatronic"],brightness:{sky:10,block:10}}
	}
	execute at @a run playsound minecraft:entity.bat.death master @a
	schedule 5t replace {
		kill @e[tag=animatronic_head]
		stopsound @a master minecraft:entity.bat.death
	}
}

function test_shader {
	function util:trigger_shader
	schedule 5s append {
		function util:disable_shader
	}
}

function tick {
	execute unless score shutdown ak.state matches 1 run title @a[tag=crosshair,tag=!cursor] times 0 10 0
	execute unless score shutdown ak.state matches 1 run title @a[tag=crosshair,tag=!cursor] title {"text":".","font":"cursor","color":"#4e5c24"}
	execute unless score show_msg ak.state matches 1 if score set_settings ak.state matches 1 if entity @a[tag=reloaded_first_time] run {
		tag @a add crosshair
		scoreboard players set show_msg ak.state 1
		scoreboard players set set_settings ak.state 0
		tellraw @p {"text":"For the best possible experience,","color":"gold"}
		tellraw @p {"text":"please use the vanilla minecraft client (without optifine or mods),","color":"gold"}
		tellraw @p {"text":"and set the following graphics settings:","underlined":true,"color":"gold"}
		tellraw @p ""
		tellraw @p ["",{"text":"[Render distance] ","bold":true,"color":"gray"},"12"]
		tellraw @p ["",{"text":"[Simulation distance] ","bold":true,"color":"gray"},"12"]
		tellraw @p ["",{"text":"[Brightness] ","bold":true,"color":"gray"},"Moody"]
		tellraw @p ["",{"text":"[Graphics] ","bold":true,"color":"gray"},"Fabulous!"]
		tellraw @p ""
		tellraw @p ["",{"text":"The map may not function correctly if these settings aren't set","bold":true,"color":"red"}]

		tellraw @p ""
		tellraw @p {"text":"To ensure maximum compatibility please click this text.","color":"gold","underlined":true,"clickEvent":{"action":"run_command","value":"/function menu:test_shader"}}
		tellraw @p ""
		tellraw @p {"text":"If a UI appears on screen you are all set to go.","color":"green","italic":true}
		tellraw @p {"text":"If not, please click this text.","color":"red","bold":true,"underlined":true,"clickEvent":{"action":"run_command","value":"/function ui:enable_compatibility"}}

		schedule 8s append {
			scoreboard players set show_msg ak.state 0
		}
	}
	execute if block -132 -60 340 dark_oak_door[open=true] run {
		fill -132 -60 340 -132 -59 340 air
		setblock -132 -60 340 dark_oak_door[facing=west,open=false,hinge=right]
		setblock -132 -59 340 dark_oak_door[facing=west,open=false,hinge=right,half=upper]
		scoreboard players set door_open ak.state 1

		tag @p add c
		scoreboard players set gamemode save 2

		rng range 0 120 temp ak.state

		execute(if score temp ak.state matches 0..39) {
			execute at @a positioned ~ ~-10 ~ run function animatronic:remix/bonnie/spawn
			execute as @e[tag=animatronic] at @s run function animatronic:remix/bonnie/kill
		} else execute (if score temp ak.state matches 40..64) {
			execute at @a positioned ~ ~-10 ~ run function animatronic:remix/chica/spawn
			execute as @e[tag=animatronic] at @s run function animatronic:remix/chica/kill
		} else execute (if score temp ak.state matches 65..89) {
			execute at @a positioned ~ ~-10 ~ run function animatronic:remix/freddy/spawn
			execute as @e[tag=animatronic] at @s run function animatronic:remix/freddy/kill
		} else execute (if score temp ak.state matches 90..110) {
			execute at @a positioned ~ ~-10 ~ run function animatronic:remix/foxy/spawn
			execute as @e[tag=animatronic] at @s run function animatronic:remix/foxy/kill
		} else {
			function animatronic:classic/golden_freddy/kill
			schedule 20s replace {
				clear @a
				function fnaf:gameover
				scoreboard players set its_me ak.state 1
			}
		}
		
		schedule 10s replace {
			scoreboard players set door_open ak.state 0
			tag @p remove c
			scoreboard players set gamemode save 0
		}
	}


	execute as @e[tag=animatronic_head] at @p rotated ~ 0 positioned ^ ^-1 ^3.7 facing entity @p eyes run tp @s ~ ~ ~ ~ ~

    execute if score menu_trigger ak.state matches 1 if score menu ak.state matches 0 run {
		# stopsound @a master
        time set midnight
        scoreboard players set menu ak.state 1
        setblock -28 -59 244 air
        setblock -20 -59 244 air
        setblock -23 -60 249 light[level=15]
        summon item_display -22.3 -59.5 248.4 {Rotation:[10.0f,0.0f],item:{id:"minecraft:potion",Count:1b,tag:{CustomModelData:990104}},Tags:["menu_animatronic"]}

        summon text_display -25.0 -56.4 248.5 {billboard:"vertical",alignment:"left",Tags:["new_game","menu_text"],brightness:{sky:15,block:15},transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.35f,1.35f,1.35f]},text:'{"text":"New Game","font":"fnaf","color":"white"}'}
        summon text_display -25.0 -57.4 248.5 {billboard:"vertical",alignment:"left",Tags:["continue","menu_text"],brightness:{sky:15,block:15},transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.35f,1.35f,1.35f]},text:'{"text":"Continue","font":"fnaf","color":"white"}'}
        execute if score its_me ak.state matches 1 run summon text_display -25.0 -58.4 248.5 {billboard:"vertical",alignment:"left",Tags:["its_me","menu_text"],brightness:{sky:15,block:15},transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.35f,1.35f,1.35f]},text:'{"text":"IT\'S ME","font":"fnaf","color":"red"}'}
        summon item_display -23.5 -58 252.5 {item:{id:"minecraft:carrot_on_a_stick", Count:1b}, Tags:["menu_mount"]}
        ride @p mount @e[type=item_display,tag=menu_mount,limit=1]
        effect give @p minecraft:slowness infinite 2 true
        scoreboard players set foxy.phase ai -1
        summon minecraft:interaction -23.5 -57.5 252.5 {width: 2, height: 2, Tags:["menu_interact"]}

        block {
            execute if score menu ak.state matches 1 run function audio:lobby/start.all

            execute if score menu ak.state matches 1 run schedule function $block 900t replace
        }

		tellraw @p ["","Press ",{"keybind":"key.sneak","bold":true,"color":"gold"}," to go back to the lobby"]
    }
    execute unless score menu_trigger ak.state matches 1 unless score night_active ak.state matches 1 unless score cutscene_active ak.state matches 1 unless score remix_mode_active ak.state matches 1 unless score power_remix_active ak.state matches 1 at @e[type=marker,tag=menu] if entity @a[tag=!debug,distance=..3] run {
        scoreboard players set menu_trigger ak.state 1
    }
    
    scoreboard players set selected_option ak.state 0

    execute if score menu ak.state matches 1 run {
		scoreboard players set temp ak.state 0
    	title @a actionbar ""
		execute store result score temp ak.state as @p on vehicle if entity @s[tag=menu_mount]
    	execute if score temp ak.state matches 0 at @p run {
            function menu:load
            execute positioned as @e[tag=lobby_spawn,limit=1] rotated 180 0 run tp @a ~ ~ ~ ~ ~
        }

        execute as @a at @s anchored eyes facing entity @e[tag=new_game] eyes anchored feet positioned ^ ^ ^1 rotated as @s positioned ^ ^ ^-1 if entity @s[distance=..0.1] run{
            data merge entity @e[tag=new_game,limit=1] {transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.7f,1.7f,1.7f]}}
            scoreboard players set selected_option ak.state 1
            
            schedule 2t replace {
                data merge entity @e[tag=new_game,limit=1] {transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.35f,1.35f,1.35f]}}
            }
        } 

        execute as @a at @s anchored eyes facing entity @e[tag=continue] eyes anchored feet positioned ^ ^ ^1 rotated as @s positioned ^ ^ ^-1 if entity @s[distance=..0.1] run{
            data merge entity @e[tag=continue,limit=1] {transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.7f,1.7f,1.7f]}}
            scoreboard players set selected_option ak.state 2
			execute unless score night savegame matches 2.. run title @a actionbar {"text":"Night 1","bold":true, "color":"white"}
            execute if score night savegame matches 2 run title @a actionbar {"text":"Night 2","bold":true, "color":"white"}
            execute if score night savegame matches 3 run title @a actionbar {"text":"Night 3","bold":true, "color":"white"}
            execute if score night savegame matches 4 run title @a actionbar {"text":"Night 4","bold":true, "color":"white"}
            execute if score night savegame matches 5 run title @a actionbar {"text":"Night 5","bold":true, "color":"white"}
            schedule 2t replace {
                data merge entity @e[tag=continue,limit=1] {transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.35f,1.35f,1.35f]}}
            }
        } 
        
        execute as @a at @s anchored eyes facing entity @e[tag=its_me] eyes anchored feet positioned ^ ^ ^1 rotated as @s positioned ^ ^ ^-1 if entity @s[distance=..0.1] run{
            data merge entity @e[tag=its_me,limit=1] {transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.7f,1.7f,1.7f]}}
            scoreboard players set selected_option ak.state 3
            schedule 2t replace {
                data merge entity @e[tag=its_me,limit=1] {transformation:{left_rotation:[0f,0f,0f,1f],right_rotation:[0f,0f,0f,1f],translation:[0f,0f,0f],scale:[1.35f,1.35f,1.35f]}}
            }
        }
	}
}

advancement left_click {
  "criteria": {
    "requirement": {
      "trigger": "minecraft:player_hurt_entity",
      "conditions": {
        "entity": {
          "type": "minecraft:interaction",
          "nbt": "{Tags:[\"menu_interact\"]}"
        }
      }
    }
  },
  "rewards": {
    "function": "menu:interact"
  }
}

advancement right_click {
  "criteria": {
    "requirement": {
      "trigger": "minecraft:player_interacted_with_entity",
      "conditions": {
        "entity": {
          "type": "minecraft:interaction",
          "nbt": "{Tags:[\"menu_interact\"]}"
        }
      }
    }
  },
  "rewards": {
    "function": "menu:interact"
  }
}

function interact {
    advancement revoke @s only menu:left_click
    advancement revoke @s only menu:right_click
    
    execute if score selected_option ak.state matches 1 run {
        # new game of classic mode
        # start night 1
        function menu:load
        function cutscene:cutscene_1_classic
    }

    execute if score selected_option ak.state matches 2 run {
        # continue old game
        function menu:load
        execute if score night savegame matches 1 run function cutscene:cutscene_1_classic
        execute if score night savegame matches 2 run{
			title @a times 40t 80t 40t
        	title @a title ["",{"text":" 12:00  AM","font":"next_night_1"},{"text":"2nd Night","font":"next_night_2"}]
        	title @a subtitle {"text":"B","font":"cursor"}
			schedule 40t replace {
				function night:start_night_2
			}
		} 
        execute if score night savegame matches 3 run {
			title @a times 40t 80t 40t
        	title @a title ["",{"text":" 12:00  AM","font":"next_night_1"},{"text":"3rd Night","font":"next_night_2"}]
        	title @a subtitle {"text":"B","font":"cursor"}
			schedule 40t replace {
				function night:start_night_3
			}
		}
        execute if score night savegame matches 4 run {
			title @a times 40t 80t 40t
        	title @a title ["",{"text":" 12:00  AM","font":"next_night_1"},{"text":"4th Night","font":"next_night_2"}]
        	title @a subtitle {"text":"B","font":"cursor"}
			schedule 40t replace {
				function night:start_night_4
			}
		}
        execute if score night savegame matches 5 run {
			title @a times 40t 80t 40t
        	title @a title ["",{"text":" 12:00  AM","font":"next_night_1"},{"text":"5th Night","font":"next_night_2"}]
        	title @a subtitle {"text":"B","font":"cursor"}
			schedule 40t replace {
				function night:start_night_5
			}
		}
    }

    execute if score selected_option ak.state matches 3 run {
        # remix mode
        scoreboard players set gamemode save 2
		effect clear @a saturation
		execute as @p at @s run function cutscene:cutscene_1
    }
}